#ifndef CE2_DH_Error_H
#define CE2_DH_Error_H

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "CryptoEngine2.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
*  Object name     :  CE2_DH_Error.h
*  State           :  %state%
*  Creation date   :  20.03.2007
*  Last modified   :  %modify_time%
*/
/** @file
* \brief contains error codes for DH functions.
*
*  \version CE2_DH_Error.h#1:cinc:1
*  \author Yermalayeu Ihar
* \remarks Copyright (C) 2006 by Discretix Technologies Ltd. All rights reserved.
*/

  /* _DX_DH_GeneratePubPrv() error codes */
#define CE2_DH_GENERATE_PUB_PRV_GENARATOR_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x01)
#define CE2_DH_GENERATE_PUB_PRV_PRIME_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x02)
#define CE2_DH_GENERATE_PUB_PRV_Q_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x03)
#define CE2_DH_GENERATE_PUB_PRV_ILLEGAL_DH_MODE (CE2_DH_MODULE_ERROR_BASE + 0x04)
#define CE2_DH_GENERATE_PUB_PRV_USER_PUBLIC_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x05)
#define CE2_DH_GENERATE_PUB_PRV_PRIM_DATA_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x06)
#define CE2_DH_GENERATE_PUB_PRV_CLIENT_PRIVATE_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x07)
#define CE2_DH_GENERATE_PUB_PRV_CLIENT_PRIVATE_KEY_SIZE_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x08)
#define CE2_DH_GENERATE_PUB_PRV_CLIENT_PUBLIC_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x09)
#define CE2_DH_GENERATE_PUB_PRV_CLIENT_PUBLIC_KEY_SIZE_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x0A)

  /* _DX_DH_KeyDerivationFunc() error codes */
#define CE2_DH_KEY_DER_FUNC_ZZ_SECRET_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x11)
#define CE2_DH_KEY_DER_FUNC_KEYING_DATA_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x12)
#define CE2_DH_KEY_DER_FUNC_ILLEGAL_HASH_MODE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x13)

  /* _DX_DH_X942_GetSecretData error codes */
#define CE2_DH_X942_GET_SECRET_DATA_USER_PUBLIC_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x21)
#define CE2_DH_X942_GET_SECRET_DATA_PRIME_DATA_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x22)
#define CE2_DH_X942_GET_SECRET_DATA_ILLEGAL_HASH_MODE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x23)
#define CE2_DH_X942_GET_SECRET_DATA_CLIENT_PRIVATE_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x24)
#define CE2_DH_X942_GET_SECRET_DATA_SERVER_PUBLIC_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x25)
#define CE2_DH_X942_GET_SECRET_DATA_PRIME_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x26)
#define CE2_DH_X942_GET_SECRET_DATA_ILLEGAL_DER_FUNC_MODE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x27)
#define CE2_DH_X942_GET_SECRET_DATA_SECRET_KEY_DATA_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x28)

  /* _DX_DH_X942_Hybrid_GetSecretData error codes */
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_USER_PUBLIC_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x31)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_PRIME_DATA_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x32)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_ILLEGAL_HASH_MODE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x33)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_CLIENT_PRIVATE_KEY_PTR1_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x34)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_CLIENT_PRIVATE_KEY_PTR2_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x35)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_SERVER_PUBLIC_KEY_PTR1_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x36)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_SERVER_PUBLIC_KEY_PTR2_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x37)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_PRIME_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x38)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_ILLEGAL_DER_FUNC_MODE_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x39)
#define CE2_DH_X942_HYBRID_GET_SECRET_DATA_SECRET_KEY_DATA_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x3A)

  /* CE2_DH_PKCS3_GetSecretKey error codes */
#define CE2_DH_PKCS3_GET_SECRET_KEY_CLIENT_PRV_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x41)
#define CE2_DH_PKCS3_GET_SECRET_KEY_SERVER_PUB_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x42)
#define CE2_DH_PKCS3_GET_SECRET_KEY_PRIME_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x43)
#define CE2_DH_PKCS3_GET_SECRET_KEY_USER_PUBLIC_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x44)
#define CE2_DH_PKCS3_GET_SECRET_KEY_PRIME_DATA_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x45)
#define CE2_DH_PKCS3_GET_SECRET_KEY_SECRET_KEY_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x46)
#define CE2_DH_PKCS3_GET_SECRET_KEY_SECRET_KEY_SIZE_PTR_ERROR (CE2_DH_MODULE_ERROR_BASE + 0x47)

#ifdef __cplusplus
}
#endif

#endif
